/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.messaging.MessageHandler;

public class Configuration {
    public static final int STANDARD = 0;
    public static final int PDF = 1;
    public static final int AWT = 2;
    private static Hashtable standardConfiguration = new Hashtable(30);
    private static Hashtable pdfConfiguration = new Hashtable(20);
    private static Hashtable awtConfiguration = new Hashtable(20);
    private static Hashtable configuration = new Hashtable(3);

    static {
        configuration.put("standard", standardConfiguration);
        configuration.put("pdf", pdfConfiguration);
        configuration.put("awt", awtConfiguration);
    }

    public static void dumpConfiguration() {
        System.out.println("Dumping configuration: ");
        Hashtable[] hashtableArray = new Hashtable[]{standardConfiguration, pdfConfiguration, awtConfiguration};
        int n = 0;
        while (n < hashtableArray.length) {
            MessageHandler.logln("----------------------");
            Hashtable hashtable = hashtableArray[n];
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Enumeration<Object> enumeration2;
                String string = (String)enumeration.nextElement();
                MessageHandler.logln("key: " + string);
                Object v = hashtable.get(string);
                if (v instanceof String) {
                    MessageHandler.logln("   value: " + v);
                    continue;
                }
                if (v instanceof Vector) {
                    Vector vector = (Vector)v;
                    enumeration2 = vector.elements();
                    MessageHandler.log("   values: ");
                    while (enumeration2.hasMoreElements()) {
                        MessageHandler.log(String.valueOf(String.valueOf(enumeration2.nextElement())) + " - ");
                    }
                    MessageHandler.logln("");
                    continue;
                }
                if (!(v instanceof Hashtable)) continue;
                Hashtable hashtable2 = (Hashtable)v;
                enumeration2 = hashtable2.keys();
                MessageHandler.log("   values: ");
                while (enumeration2.hasMoreElements()) {
                    String string2 = (String)enumeration2.nextElement();
                    MessageHandler.log(" " + string2 + ":" + hashtable2.get(string2));
                }
                MessageHandler.logln("");
            }
            ++n;
        }
    }

    public static Boolean getBooleanValue(String string) {
        return Configuration.getBooleanValue(string, 0);
    }

    public static Boolean getBooleanValue(String string, int n) {
        Object object = Configuration.getValue(string, n);
        if (object instanceof String) {
            return new Boolean((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return null;
    }

    public static Hashtable getConfiguration() {
        return configuration;
    }

    public static Vector getFonts() {
        return (Vector)Configuration.getValue("fonts", 0);
    }

    public static Hashtable getHashtableValue(String string) {
        return Configuration.getHashtableValue(string, 0);
    }

    public static Hashtable getHashtableValue(String string, int n) {
        Object object = Configuration.getValue(string, n);
        if (object instanceof Hashtable) {
            return (Hashtable)object;
        }
        return null;
    }

    public static int getIntValue(String string) {
        return Configuration.getIntValue(string, 0);
    }

    public static int getIntValue(String string, int n) {
        Object object = Configuration.getValue(string, n);
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        return -1;
    }

    public static Vector getListValue(String string) {
        return Configuration.getListValue(string, 0);
    }

    public static Vector getListValue(String string, int n) {
        Object object = Configuration.getValue(string, n);
        if (object instanceof Vector) {
            return (Vector)object;
        }
        return null;
    }

    public static String getStringValue(String string) {
        return Configuration.getStringValue(string, 0);
    }

    public static String getStringValue(String string, int n) {
        Object object = Configuration.getValue(string, n);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static Object getValue(String string) {
        return Configuration.getValue(string, 0);
    }

    public static Object getValue(String string, int n) {
        switch (n) {
            case 0: {
                return standardConfiguration.get(string);
            }
            case 1: {
                return pdfConfiguration.get(string);
            }
            case 2: {
                return awtConfiguration.get(string);
            }
        }
        return standardConfiguration.get(string);
    }

    public static void put(String string, Object object) {
        Configuration.put(string, object, 0);
    }

    public static void put(String string, Object object, int n) {
        switch (n) {
            case 0: {
                standardConfiguration.put(string, object);
                break;
            }
            case 1: {
                pdfConfiguration.put(string, object);
                break;
            }
            case 2: {
                awtConfiguration.put(string, object);
                break;
            }
            default: {
                standardConfiguration.put(string, object);
                MessageHandler.errorln("Unknown role for new configuration entry. Putting key:" + string + " - value:" + object + " into standard configuration.");
            }
        }
    }

    public static void setup(int n, Hashtable hashtable) {
        switch (n) {
            case 0: {
                standardConfiguration = hashtable;
                break;
            }
            case 1: {
                pdfConfiguration = hashtable;
                break;
            }
            case 2: {
                awtConfiguration = hashtable;
                break;
            }
            default: {
                MessageHandler.errorln("Can't setup configuration. Unknown configuration role/target");
            }
        }
    }
}

