/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.URL;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.CommandLineStarter;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.PreviewDialog;
import org.apache.fop.viewer.SecureResourceBundle;
import org.apache.fop.viewer.Translator;
import org.apache.fop.viewer.UserMessage;
import org.xml.sax.XMLReader;

public class AWTStarter
extends CommandLineStarter {
    PreviewDialog frame;
    AWTRenderer renderer;
    public static String TRANSLATION_PATH = "/org/apache/fop/viewer/resources/";
    private Translator resource;

    public AWTStarter(CommandLineOptions commandLineOptions) throws FOPException {
        super(commandLineOptions);
        this.init();
    }

    protected PreviewDialog createPreviewDialog(AWTRenderer aWTRenderer, Translator translator) {
        PreviewDialog previewDialog = new PreviewDialog(aWTRenderer, translator);
        previewDialog.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = previewDialog.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        ((Component)previewDialog).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)previewDialog).setVisible(true);
        return previewDialog;
    }

    private SecureResourceBundle getResourceBundle(String string) {
        InputStream inputStream = null;
        try {
            URL uRL = this.getClass().getResource(string);
            inputStream = uRL.openStream();
        }
        catch (Exception exception) {
            this.log.error("Can't find URL to: <" + string + "> " + exception.getMessage(), (Throwable)exception);
        }
        return new SecureResourceBundle(inputStream);
    }

    private void init() {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = this.commandLineOptions.getLanguage();
        if (string == null) {
            try {
                string = System.getProperty("user.language");
            }
            catch (SecurityException securityException) {}
        }
        this.resource = this.getResourceBundle(String.valueOf(TRANSLATION_PATH) + "resources." + string);
        UserMessage.setTranslator(this.getResourceBundle(String.valueOf(TRANSLATION_PATH) + "messages." + string));
        this.resource.setMissingEmphasized(false);
        this.renderer = new AWTRenderer(this.resource);
        this.frame = this.createPreviewDialog(this.renderer, this.resource);
        this.renderer.setProgressListener(this.frame);
        this.renderer.setComponent(this.frame);
    }

    public void run() throws FOPException {
        Driver driver = new Driver();
        driver.setLogger(this.log);
        if (this.errorDump) {
            driver.setErrorDump(true);
        }
        this.frame.progress(String.valueOf(this.resource.getString("Init parser")) + " ...");
        XMLReader xMLReader = this.inputHandler.getParser();
        if (xMLReader == null) {
            throw new FOPException("Unable to create SAX parser");
        }
        this.setParserFeatures(xMLReader);
        try {
            driver.setRenderer(this.renderer);
            this.frame.progress(String.valueOf(this.resource.getString("Build FO tree")) + " ...");
            driver.render(xMLReader, this.inputHandler.getInputSource());
            this.frame.progress(this.resource.getString("Show"));
            this.frame.showPage();
        }
        catch (Exception exception) {
            if (exception instanceof FOPException) {
                throw (FOPException)exception;
            }
            throw new FOPException(exception);
        }
    }
}

